<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class HmoFormSafetyArrangements extends Model 
{

    protected $table = 'hmo_form_safety_arrangements';
    public $timestamps = true;
    protected $fillable = array('hmo_form_id', 'fire_detection', 'control_panel', 'heat_detectors', 'smoke_detectors_in_rooms', 'room_smoke_detector_battery_powered', 'common_smoke_detector', 'common_smoke_detector_battery_powered', 'alarm_sounders', 'system_tested', 'fire_doors', 'fire_blankets', 'safety_equipment_serviced', 'fire_safety_training_provided', 'training_details', 'fire_risk_assessment_carried_out', 'gas_appliances', 'gas_appliances_legal', 'gas_appliances_checked', 'plh_gas_appliances_decarlation', 'furniture_provided', 'furniture_complies', 'plh_furniture_declaration', 'electrical_appliances', 'electricals_pat_tested', 'plh_electricals_declaration');

    public function hmoForm()
    {
        return $this->belongsTo('HmoForm', 'hmo_form_id');
    }

}